local t = Def.ActorFrame {};

local function Update(self)
	local c = self:GetChildren();
	local bps = GAMESTATE:GetSongBPS() or 1
	c.TextureStripe:texcoordvelocity(5,0);
end

local function IsVisible()
	local r = Screen.String("HeaderText");
	return string.len(r) > 0 and true or false
end

t[#t+1] = Def.Quad {
	InitCommand=cmd(vertalign,top;zoomto,SCREEN_WIDTH+1,50;diffuse,color("#000000"));
}
t[#t+1] = LoadActor("_texture stripe") .. {
	Name="TextureStripe";
	InitCommand=cmd(x,-SCREEN_CENTER_X-8;y,-2;horizalign,left;vertalign,top;zoomto,720,50;customtexturerect,0,0,32,0);
	OnCommand=cmd(texcoordvelocity,5,0;skewx,-0.0175;diffuse,color("#000077");diffuserightedge,color("#00007700"));
};
t[#t+1] = LoadActor("Header") .. {
	InitCommand=cmd(y,1;vertalign,top;zoomtowidth,SCREEN_WIDTH+1;diffuse,color("#0080ff"));
	OnCommand=cmd(croptop,46/60);
};

t[#t+1] = LoadFont("Common Bold") .. {
	Name="HeaderShadow";
	Text=Screen.String("HeaderText");
	InitCommand=cmd(x,-SCREEN_CENTER_X+28;y,30;zoom,1;horizalign,left;maxwidth,720);
	OnCommand=cmd(visible,IsVisible();skewx,-0.125;diffuse,BoostColor(color("#0000ff88"),0.375););
	UpdateScreenHeaderMessageCommand=function(self,param)
		self:settext(param.Header);
	end;
};

t[#t+1] = Def.Quad {
	Name="Underline";
	InitCommand=cmd(x,-SCREEN_CENTER_X+20;y,42;horizalign,left);
	OnCommand=cmd(stoptweening;diffuse,color("#0000ff");shadowlength,2;shadowcolor,BoostColor(color("#0080ff77"),0.25);linear,0.25;zoomtowidth,720;fadeleft,8/192;faderight,0.5;
		visible,string.len( Screen.String("HeaderText") ) > 0 );
};

t[#t+1] = LoadFont("Common Bold") .. {
	Name="HeaderText";
	Text=Screen.String("HeaderText");
	InitCommand=cmd(x,-SCREEN_CENTER_X+24;y,26;zoom,1;horizalign,left;shadowlength,0;maxwidth,720);
	OnCommand=cmd(visible,IsVisible();skewx,-0.125;diffuse,color("#0000ff"););
	UpdateScreenHeaderMessageCommand=function(self,param)
		self:settext(param.Header);
	end;
};

t[#t+1] = LoadFont("Common Normal")..{
	Name="Clock";
	InitCommand=cmd(x,360;y,10;diffuse,color("1,1,1,1");strokecolor,color("1,0.75,0,0.6");zoom,0.5;maxwidth,SCREEN_WIDTH;queuecommand,"Set";);
	SetCommand=cmd(settext, string.format("%04i/%02i/%02i   %02i:%02i:%02i", Year(), MonthOfYear()+1,DayOfMonth(), Hour(), Minute(), Second());sleep,1;queuecommand,"Set";);
};

t.BeginCommand=function(self)
	self:SetUpdateFunction( Update );
end

return t
